﻿<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" AutoEventWireup="false" codePage="65001" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Kadry" %>
<%@ import Namespace="Soneta.Kalend" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Deklaracje" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zaświadczenie o zgłoszeniu do ubezpieczenia zdrowotnego</title>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
		<script runat="server">
            void OnContextLoad(object sender, EventArgs e) {
                PracHistoria ph = (PracHistoria)dc[typeof(PracHistoria)];
                Date dataWypełnienia = Date.Today;
                LiczDanePłatnika(ph.Pracownik, dataWypełnienia);
                if (ph.ImieDrugie == "")
                    flImiona.EditValue = ph.Imie;
                else
                    flImiona.EditValue = ph.Imie + ", " + ph.ImieDrugie;
                flPesel.EditValue = Dokument(ph.PESEL, ph.NIP, ph.Dokument.Rodzaj, ph.Dokument.SeriaNumer);
                flDataZgloszenia.Text = DataZgloszeniaDoUbezpieczeniaZdrowotnego(ph);
                FromTo oz = ph.Etat.OkresZatrudnienia;
                if (ph.Etat.Ubezpieczenia.Zdrowotne.Okres == FromTo.Empty)
                    flDataZwolnienia.Text = string.Format(flDataZwolnienia.Text, "nieokreślony / określony do ……-……-………r.") + " <strong>Nie dotyczy</strong>";
                else if (ph.Etat.TypUmowy == TypUmowyOPrace.NaCzasNieokreślony)
                    flDataZwolnienia.Text = string.Format(flDataZwolnienia.Text, "nieokreślony / " + Przekreśl("określony do ………-…………-……………r."));
                else
                    flDataZwolnienia.Text = string.Format(flDataZwolnienia.Text, Przekreśl("nieokreślony") + string.Format(" / określony do <strong>{0:dd-MM-yyyy}</strong> r.", oz.To));
                Date doDnia = ph.Etat.OkresZatrudnienia.To;
                if (ph.Etat.Ubezpieczenia.Zdrowotne.Okres == FromTo.Empty)
                    flDataRozwiazania.Text = string.Format(flDataRozwiazania.Text, "jest / nie jest", "……-……-………") + " <strong>Nie dotyczy</strong>";
                else if (ph.Etat.TypUmowy == TypUmowyOPrace.NaCzasNieokreślony && doDnia < Date.MaxValue)
                    flDataRozwiazania.Text = string.Format(flDataRozwiazania.Text, "jest / " + Przekreśl("nie jest"), string.Format("<strong>{0:dd-MM-yyyy}</strong>", doDnia));
                else {
                    Date złożony = ph.Etat.OkresWypowiedzenia.DataZlozenia;
                    Date upływa = ph.Etat.OkresWypowiedzenia.Uplywa;
                    bool jest = złożony != Date.Empty || upływa != Date.Empty;
                    flDataRozwiazania.Text = string.Format(flDataRozwiazania.Text,
                        Przekreśl("jest", !jest) + " / " + Przekreśl("nie jest", jest),
                        upływa == Date.Empty ? "………-…………-……………" : string.Format("<strong>{0:dd-MM-yyyy}</strong>", upływa));
                }
                KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik);
                INieobecnosc n = kalk.Nieobecnosc(dataWypełnienia);
                if (n != null && n.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopBezpłatny) {
                    FromTo on = n.Okres;
                    while ((n = kalk.Nieobecnosc(on.From - 1)) != null && n.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopBezpłatny)
                        on = new FromTo(n.Okres.From, on.To);
                    while ((n = kalk.Nieobecnosc(on.To + 1)) != null && n.Definicja.Przyczyna == PrzyczynaNieobecnosci.UrlopBezpłatny)
                        on = new FromTo(on.From, n.Okres.To);
                    flWychowawczy.Text = string.Format(flWychowawczy.Text, string.Format("przebywa / " + Przekreśl("nie przebywa") + " ** na urlopie bezpłatnym : od <strong>{0:dd-MM-yyyy}</strong> r. do <strong>{1:dd-MM-yyyy}</strong> r.", on.From, on.To));
                }
                else
                    flWychowawczy.Text = string.Format(flWychowawczy.Text, Przekreśl("przebywa") + " / nie przebywa ** na urlopie bezpłatnym : " + Przekreśl(" od ………-…………-……… r. do ………-…………-……… r."));
                int i = 0;
                bool rodzina = false;
                foreach (CzlonekRodziny osoba in ph.Pracownik.Rodzina)
                    if (osoba.UbezpieczenieOkres.Contains(dataWypełnienia)) {
                        rodzina = true;
                        switch (i++) {
                            case 0: DodajRodzina(osoba, flOsoba1, flData1, flPesel1, flZgloszenie1); break;
                            case 1: DodajRodzina(osoba, flOsoba2, flData2, flPesel2, flZgloszenie2); break;
                            case 2: DodajRodzina(osoba, flOsoba3, flData3, flPesel3, flZgloszenie3); break;
                            case 3: DodajRodzina(osoba, flOsoba4, flData4, flPesel4, flZgloszenie4); break;
                            case 4: DodajRodzina(osoba, flOsoba5, flData5, flPesel5, flZgloszenie5); break;
                        }
                    }
                flOswiadczenie.Text = string.Format(flOswiadczenie.Text,
                    ph.Imie + " " + ph.Nazwisko,
                    Przekreśl("oraz wymienieni członkowie rodziny", !rodzina));
                flDataWypelnienia.Text = string.Format(flDataWypelnienia.Text, dataWypełnienia);
                if (ph.AdresZamieszkania.Miejscowosc.Length > 0 ||
                    ph.AdresZamieszkania.KodPocztowyS.Length > 0 ||
                    ph.AdresZamieszkania.Ulica.Length > 0 ||
                    ph.AdresZamieszkania.NrDomu.Length > 0 ||
                    ph.AdresZamieszkania.NrLokalu.Length > 0) {
                    flMiejscowość2.EditValue = ph.AdresZamieszkania.Miejscowosc;
                    flKodPocztowy3.EditValue = ph.AdresZamieszkania.KodPocztowyS;
                    flMiejscowość3.EditValue = ph.AdresZamieszkania.Ulica;
                    flKodPocztowy4.EditValue = ph.AdresZamieszkania.NrDomu;
                    flKodPocztowy5.EditValue = ph.AdresZamieszkania.NrLokalu;
                }
                else {
                    flMiejscowość2.EditValue = ph.Adres.Miejscowosc;
                    flKodPocztowy3.EditValue = ph.Adres.KodPocztowyS;
                    flMiejscowość3.EditValue = ph.Adres.Ulica;
                    flKodPocztowy4.EditValue = ph.Adres.NrDomu;
                    flKodPocztowy5.EditValue = ph.Adres.NrLokalu;
                }
            }
            class UmowyComparer : IComparer {
                public int Compare(object x, object y) {
                    return ((Umowa)x).Okres.From.CompareTo(((Umowa)y).Okres.From);
                }
            }
            string DataZgloszeniaDoUbezpieczeniaZdrowotnego(PracHistoria ph) {
                Date dataZgloszenia = Date.Empty;
                
                if (ph.Etat.Ubezpieczenia.Zdrowotne.Okres != FromTo.Empty)
                    dataZgloszenia = ph.Etat.Ubezpieczenia.Zdrowotne.Okres.From;
                else {
                    ArrayList list = new ArrayList(KadryModule.GetInstance(dc).Umowy.WgPracownik[ph.Pracownik]);
                    list.Sort(new UmowyComparer());
                    FromTo prevOkres = FromTo.Empty;
                    foreach (Umowa um in list) {
                        if (dataZgloszenia == Date.Empty ||
                            (prevOkres.To != Date.MaxValue && prevOkres.To < um.Okres.From - 1))
                            dataZgloszenia = um.Ubezpieczenia.Zdrowotne.Okres.From;
                        prevOkres = um.Okres;
                    }
                }
                
                return string.Format(flDataZgloszenia.Text, dataZgloszenia);
            }
            void DodajRodzina(CzlonekRodziny osoba, FrameLabel flOsoba, FrameLabel flData, FrameLabel flPesel, FrameLabel flZgloszenie) {
                flOsoba.EditValue = osoba.Nazwisko + " " + osoba.Imie;
                flData.EditValue = osoba.Urodzony.Data;
                flPesel.EditValue = Dokument(osoba.PESEL, osoba.NIP, osoba.Dokument.Rodzaj, osoba.Dokument.SeriaNumer);
                flZgloszenie.EditValue = osoba.UbezpieczenieOkres.From;
            }
            string Dokument(string pesel, string nip, KodRodzajuDokumentu dokument, string numer) {
                if (pesel != "")
                    return pesel;
                //if (nip != "")
                //    return "NIP, " + nip;
                if (dokument == KodRodzajuDokumentu.DowodOsobisty)
                    return "Dowód osobisty, " + numer;
                if (dokument == KodRodzajuDokumentu.Paszport)
                    return "Paszport, " + numer;
                return "";
            }
            string przekreślOn = "<font style=\"text-decoration: line-through\">";
            string przekreślOff = "</font>";
            string Przekreśl(string tekst) {
                return Przekreśl(tekst, true);
            }
            string Przekreśl(string tekst, bool przekreśl) {
                if (!przekreśl)
                    return tekst;
                return przekreślOn + tekst + przekreślOff;
            }
            void LiczDanePłatnika(Pracownik pracownik, Date dataWypełnienia) {
                string nazwa;
                IAdres adres;
                string regon;
                string nip;
                Wlasciciel wls = null;
                CoreModule core = CoreModule.GetInstance(pracownik);
                DeklaracjeModule deklaracje = DeklaracjeModule.GetInstance(pracownik);
                if (core.Config.Firma.DaneEwidencyjne.OsobaFizyczna)
                    wls = deklaracje.Config.ZUS.Ogólne.DaneWłaściciela;
                if (wls != null) {
                    nazwa = GetNazwaSkrócona(pracownik);
                    PracHistoria wh = wls == null ? null : wls[dataWypełnienia];
                    nip = wh.NIP;
                    regon = core.Config.Firma.Pieczątka.REGON;
                    adres = core.Config.Firma.AdresSiedziby;
                }
                else {
                    Wydzial w = pracownik.Wydzial;
                    OddzialFirmy of = w == null ? null : w.WyliczOddzial();
                    if (of == null) {
                        nazwa = GetNazwaSkrócona(pracownik);
                        regon = core.Config.Firma.Pieczątka.REGON;
                        nip = core.Config.Firma.Pieczątka.NIP;
                        adres = core.Config.Firma.AdresSiedziby;
                    }
                    else {
                        nazwa = of.NazwaSkrocona;
                        regon = of.Deklaracje.REGON;
                        nip = of.Deklaracje.NIP;
                        adres = of.Adres;
                    }
                }
                flFirmaNazwa.Text = nazwa;
                flFirmaMiejscowosc.EditValue = adres.Miejscowosc;
                flFirmaKodPocztowy.EditValue = adres.KodPocztowyS;
                flFirmaUlica.EditValue = adres.Ulica;
                flFirmaNrDomu.EditValue = adres.NrDomu;
                flFirmaNrLokalu.EditValue = adres.NrLokalu;
                flFirmaNIP.EditValue = regon + "/" + nip;
                flFirmaTel.EditValue = adres.Telefon;
            }
            static string GetNazwaSkrócona(ISessionable session) {
                string nazwaSkrócona = DeklaracjeModule.GetInstance(session).Config.ZUS.Ogólne.NazwaSkrócona;
                if (nazwaSkrócona == "")
                    nazwaSkrócona = CoreModule.GetInstance(session).Config.Firma.Pieczątka.NazwaSkrócona;
                return nazwaSkrócona;
            }
</script>
	</HEAD>
	<body leftMargin="0" rightMargin="0">
		<form id="PIT_2_2" method="post" runat="server">
<ea:framelabel id="FrameLabel34" style="Z-INDEX: 105; LEFT: 0px; POSITION: absolute; TOP: 0px; height: 28px;"
				runat="server" 
                Text="ZAŚWIADCZENIE" 
                FrameStyle="BigBold" HorizontalAlign="Center" 
            VerticalAlign="Middle" Width="630px" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 256; LEFT: 0px; POSITION: absolute; TOP: 28px; height: 28px;"
				runat="server" 
                Text="Uwaga: Należy wypełnić czytelnie pismem maszynowym lub odręcznie drukowanymi literami." 
                FrameStyle="Middle" HorizontalAlign="Center" 
                Width="630px" VerticalAlign="Middle" FrameBorderStyle="None"></ea:FrameLabel>
<ea:framelabel id="Framelabel81" style="Z-INDEX: 141; LEFT: 0px; POSITION: absolute; TOP: 56px; height: 28px;"
				runat="server" Width="630px" 
                Text="1. DANE PŁATNIKA SKŁADKI NA UBEZPIECZENIE ZDROWOTNE" 
                FrameStyle="BigYellowBold" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 141; LEFT: 0px; POSITION: absolute; TOP: 84px; height: 28px; width: 628px; right: 303px;"
				runat="server" 
                Text="1.1 Nazwa:" 
                FrameStyle="BigBold" Height="28px" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel id="flFirmaNazwa" style="Z-INDEX: 141; LEFT: 105px; POSITION: absolute; TOP: 84px; height: 28px; width: 522px;"
				runat="server" Height="28px" VerticalAlign="Middle" FrameBorderStyle="None" 
            FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="Framelabel103" style="Z-INDEX: 143; LEFT: 0px; POSITION: absolute; TOP: 112px; width: 89px; right: 762px; height: 81px;"
				runat="server" Text="1.2 Adres" FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="flFirmaMiejscowosc" style="Z-INDEX: 144; LEFT: 91px; POSITION: absolute; TOP: 112px; right: 548px; width: 237px;"
				runat="server" Height="28px" 
                Text="&lt;.Normal&gt;Miejscowość:"></ea:framelabel>
<ea:framelabel id="flFirmaKodPocztowy" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 112px; right: 485px; width: 301px;"
				runat="server" Height="28px" 
                Text="&lt;.Normal&gt;Kod pocztowy:" ValueStyle="PostalCode"></ea:framelabel>
<ea:framelabel id="flFirmaUlica" style="Z-INDEX: 144; LEFT: 91px; POSITION: absolute; TOP: 140px; right: 548px; width: 237px;"
				runat="server" Height="28px" 
                Text="&lt;.Normal&gt;Ulica:"></ea:framelabel>
<ea:framelabel id="flFirmaNrDomu" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 140px; right: 464px; width: 145px;"
				runat="server" Height="28px" 
                Text="&lt;.Normal&gt;Nr domu:"></ea:framelabel>
<ea:framelabel id="flFirmaNrLokalu" style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 140px; right: 485px; width: 154px;"
				runat="server" Height="28px" 
                Text="&lt;.Normal&gt;Nr lokalu:" Bold="False"></ea:framelabel>
<ea:framelabel id="flFirmaNIP" style="Z-INDEX: 144; LEFT: 91px; POSITION: absolute; TOP: 168px; right: 604px; width: 237px;"
				runat="server" Height="28px" 
                Text="&lt;.Normal&gt;Regon/NIP:" Bold="False"></ea:framelabel>
<ea:framelabel id="flFirmaTel" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 168px; right: 485px; width: 299px;"
				runat="server" Height="28px" 
                Text="&lt;.Normal&gt;Ewentualny telefon:"></ea:framelabel>
<ea:framelabel id="Framelabel158" style="Z-INDEX: 141; LEFT: 0px; POSITION: absolute; TOP: 196px; height: 28px;"
				runat="server" Width="630px" 
                Text="2. DANE UBEZPIECZONEGO" 
                FrameStyle="BigYellowBold" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 224px; right: 548px; width: 182px; height: 39px;"
				runat="server" 
                Text="2.1&lt;.Normal&gt; Nazwisko" DataMember="Nazwisko"></ea:framelabel>
<ea:framelabel id="flImiona" style="Z-INDEX: 144; LEFT: 182px; POSITION: absolute; TOP: 224px; right: 548px; width: 145px; height: 41px;"
				runat="server" 
                Text="2.2&lt;.Normal&gt; Imię (imiona)"></ea:framelabel>
<ea:framelabel id="flImiona0" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 224px; right: 457px; width: 145px; height: 41px;"
				runat="server" 
                Text="2.3&lt;.Normal&gt; Data urodzenia" DataMember="Urodzony.Data" 
            Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 224px; right: 548px; width: 156px; height: 41px;"
				runat="server" 
                Text="2.4&lt;.Normal&gt;PESEL/inny numer identyfikacyjny*" 
            ID="flPesel"></ea:framelabel>
<ea:framelabel id="Framelabel159" style="Z-INDEX: 143; LEFT: 0px; POSITION: absolute; TOP: 266px; width: 89px; right: 762px; height: 81px;"
				runat="server" Text="2.5 Adres" FrameStyle="BigBold"></ea:framelabel>
<ea:framelabel id="flMiejscowość2" style="Z-INDEX: 144; LEFT: 91px; POSITION: absolute; TOP: 266px; right: 548px; width: 237px; height: 43px;"
				runat="server" 
                Text="&lt;.Normal&gt;Miejscowość:"></ea:framelabel>
<ea:framelabel id="flKodPocztowy3" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 266px; right: 485px; width: 301px; height: 39px;"
				runat="server" 
                Text="&lt;.Normal&gt;Kod pocztowy:"></ea:framelabel>
<ea:framelabel id="flMiejscowość3" style="Z-INDEX: 144; LEFT: 91px; POSITION: absolute; TOP: 308px; right: 604px; width: 237px; height: 45px;"
				runat="server" 
                Text="&lt;.Normal&gt;Ulica:"></ea:framelabel>
<ea:framelabel id="flKodPocztowy4" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 308px; right: 464px; width: 147px; height: 41px;"
				runat="server" 
                Text="&lt;.Normal&gt;Nr domu:"></ea:framelabel>
<ea:framelabel id="flKodPocztowy5" style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 308px; right: 485px; width: 152px; height: 40px;"
				runat="server" 
                Text="&lt;.Normal&gt;Nr lokalu:"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 253; LEFT: 0px; POSITION: absolute; TOP: 350px; height: 30px; width: 630px;"
				runat="server" 
                Text="&lt;strong&gt;2.6&lt;/strong&gt; Data zgłoszenia do ubezpieczenia zdrowotnego (dd/mm/rrrr): &lt;strong&gt;{0:dd-MM-yyyy}&lt;/strong&gt; r." 
                FrameStyle="Middle" HorizontalAlign="Left" VerticalAlign="Middle" 
            ID="flDataZgloszenia" FrameBorderStyle="None"></ea:FrameLabel>
<ea:framelabel style="Z-INDEX: 254; LEFT: 0px; POSITION: absolute; TOP: 350px; height: 114px;"
				runat="server" 
                FrameStyle="Middle" HorizontalAlign="Center" 
                Width="630px" VerticalAlign="Middle" ID="framelabel160"></ea:FrameLabel>
<ea:framelabel style="Z-INDEX: 252; LEFT: 0px; POSITION: absolute; TOP: 378px; height: 30px; width: 630px;"
				runat="server" 
                Text="&lt;strong&gt;2.7&lt;/strong&gt; Pracownik jest zatrudniony na czas {0} **" 
                FrameStyle="Middle" HorizontalAlign="Left" VerticalAlign="Middle" 
            ID="flDataZwolnienia" Bold="False" FrameBorderStyle="None"></ea:FrameLabel>
<ea:framelabel style="Z-INDEX: 251; LEFT: 0px; POSITION: absolute; TOP: 406px; height: 30px; width: 630px;"
				runat="server" 
                Text="&lt;strong&gt;2.8&lt;/strong&gt; Pracownik {0} ** w okresie wypowiedzenia. Data rozwiązania umowy o pracę {1} r." 
                FrameStyle="Middle" HorizontalAlign="Left" VerticalAlign="Middle" 
            ID="flDataRozwiazania" FrameBorderStyle="None"></ea:FrameLabel>
<ea:framelabel style="Z-INDEX: 250; LEFT: 0px; POSITION: absolute; TOP: 434px; height: 30px; width: 630px;"
				runat="server" 
                Text="&lt;strong&gt;2.9&lt;/strong&gt; Pracownik {0}" 
                FrameStyle="Middle" HorizontalAlign="Left" VerticalAlign="Middle" 
            ID="flWychowawczy" FrameBorderStyle="None"></ea:FrameLabel>
<ea:framelabel id="Framelabel165" style="Z-INDEX: 141; LEFT: 0px; POSITION: absolute; TOP: 462px; height: 28px;"
				runat="server" Width="630px" 
                Text="3. DANE CZŁONKÓW RODZINY ZGŁOSZONYCH DO UBEZPIECZENIA" 
                FrameStyle="BigYellowBold" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 490px; right: 751px; width: 182px;"
				runat="server" Height="28px" 
                Text="&lt;strong&gt;3.1&lt;/strong&gt; Nazwisko i imię" 
            ID="framelabel166" FrameStyle="Middle" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel id="flImiona1" style="Z-INDEX: 144; LEFT: 182px; POSITION: absolute; TOP: 490px; right: 548px; width: 145px;"
				runat="server" Height="28px" 
                Text="&lt;strong&gt;3.2&lt;/strong&gt; Data urodzenia" 
            FrameStyle="Middle" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel id="flImiona2" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 490px; right: 457px; width: 145px;"
				runat="server" Height="28px" 
            Text="&lt;strong&gt;3.3&lt;/strong&gt; PESEL/inny numer identyfikacyjny*" 
            FrameStyle="Middle" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 490px; right: 548px; width: 156px;"
				runat="server" Height="28px" 
                Text="&lt;strong&gt;3.4&lt;/strong&gt; Data zgłoszenia do ubezpieczenia zdrowotnego" 
            ID="flPesel0" FrameStyle="Middle" VerticalAlign="Middle"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 518px; right: 548px; width: 182px; height: 41px;"
				runat="server" ID="flOsoba1"></ea:framelabel>
<ea:framelabel id="flData1" style="Z-INDEX: 144; LEFT: 182px; POSITION: absolute; TOP: 518px; right: 548px; width: 145px; height: 41px;"
				runat="server" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel id="flPesel1" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 518px; right: 457px; width: 145px; height: 40px;"
				runat="server"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 518px; right: 548px; width: 156px; height: 39px;"
				runat="server" 
            ID="flZgloszenie1" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 560px; right: 548px; width: 182px; height: 41px;"
				runat="server" ID="flOsoba2"></ea:framelabel>
<ea:framelabel id="flData2" style="Z-INDEX: 144; LEFT: 182px; POSITION: absolute; TOP: 560px; right: 548px; width: 145px; height: 41px;"
				runat="server" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel id="flPesel2" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 560px; right: 457px; width: 145px; height: 39px;"
				runat="server"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 560px; right: 548px; width: 156px; height: 39px;"
				runat="server" 
            ID="flZgloszenie2" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 602px; right: 548px; width: 182px; height: 39px;"
				runat="server" ID="flOsoba3"></ea:framelabel>
<ea:framelabel id="flData3" style="Z-INDEX: 144; LEFT: 182px; POSITION: absolute; TOP: 602px; right: 548px; width: 145px; height: 42px;"
				runat="server" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel id="flPesel3" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 602px; right: 457px; width: 145px; height: 40px;"
				runat="server"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 602px; right: 548px; width: 156px; height: 42px;"
				runat="server" 
            ID="flZgloszenie3" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 644px; right: 751px; width: 182px; height: 44px;"
				runat="server" ID="flOsoba4"></ea:framelabel>
<ea:framelabel id="flData4" style="Z-INDEX: 144; LEFT: 182px; POSITION: absolute; TOP: 644px; right: 548px; width: 145px; height: 44px;"
				runat="server" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel id="flPesel4" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 644px; right: 457px; width: 145px; height: 41px;"
				runat="server"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 644px; right: 548px; width: 156px; height: 45px;"
				runat="server" 
            ID="flZgloszenie4" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 686px; right: 751px; width: 182px; height: 44px;"
				runat="server" ID="flOsoba5"></ea:framelabel>
<ea:framelabel id="flData5" style="Z-INDEX: 144; LEFT: 182px; POSITION: absolute; TOP: 686px; right: 682px; width: 145px; height: 44px;"
				runat="server" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel id="flPesel5" style="Z-INDEX: 144; LEFT: 329px; POSITION: absolute; TOP: 686px; right: 457px; width: 145px; height: 41px;"
				runat="server"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 476px; POSITION: absolute; TOP: 686px; right: 548px; width: 156px; height: 45px;"
				runat="server" 
            ID="flZgloszenie5" Format="{0:dd-MM-yyyy}"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 249; LEFT: 20px; POSITION: absolute; TOP: 742px; height: 67px; width: 586px; right: 403px;"
				runat="server" 
                Text="Zaświadczam, że Pan/Pani &lt;strong&gt;{0}&lt;/strong&gt; (imię i nazwisko) {1}*** został/została/zostali zgłoszony/zgłoszona/zgłoszeni do ubezpieczenia zdrowotnego w Narodowym Funduszu Zdrowia i do dnia dzisiejszego nie został/została/zostali przeze mnie wyrejestrowani. Składki na ubezpieczenie zdrowotne opłacane są w terminach i na zasadach określonych w ustawie z dnia 27 sierpnia 2004 r. o świadczeniach opieki zdrowotnej finansowanych ze środków publicznych (Dz. U. z 2008, Nr 164 poz. 1027 z późn. zm.)" 
                FrameStyle="Middle" HorizontalAlign="Left" VerticalAlign="Middle" 
            ID="flOswiadczenie" FrameBorderStyle="None"></ea:FrameLabel>
<ea:framelabel style="Z-INDEX: 144; LEFT: 0px; POSITION: absolute; TOP: 837px; right: 548px; width: 314px; height: 35px;"
				runat="server" 
            Text="&lt;strong&gt;{0:dd-MM-yyyy}&lt;/strong&gt; r.|data wypełnienia zaświadczenia (dd/mm/rrrr)" 
            ID="flDataWypelnienia" FrameStyle="Middle" HorizontalAlign="Center" 
            FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel id="flImiona5" style="Z-INDEX: 144; LEFT: 315px; POSITION: absolute; TOP: 837px; right: 303px; width: 313px; height: 37px;"
				runat="server" 
            Text="………………………………………….|firmowa pieczątka płatnika składki oraz imienna pieczątka i podpis osoby upoważnionej do wystawienia zaświadczenia" 
            FrameStyle="Middle" HorizontalAlign="Center" FrameBorderStyle="None"></ea:framelabel>
<ea:framelabel style="Z-INDEX: 255; LEFT: 0px; POSITION: absolute; TOP: 862px; height: 55px; right: 303px;"
				runat="server" 
                Text="* W przypadku podania innego niż PESEL numeru identyfikacyjnego, należy podać rodzaj dokumentu zawierającego wskazany numer. |** Niepotrzebne skreślić|*** Jeśli członkowie rodziny nie zostali wymienieni w Zaświadczeniu proszę skreślić." 
                FrameStyle="Middle" HorizontalAlign="Left" 
                Width="630px" VerticalAlign="Middle" ID="framelabel170" 
            FrameBorderStyle="None"></ea:FrameLabel>
<ea:datacontext id="dc" style="Z-INDEX: 257; LEFT: 9px; POSITION: absolute; TOP: 897px" runat="server"
				TypeName="Soneta.Kadry.PracHistoria,Soneta.KadryPlace" 
                oncontextload="OnContextLoad" LeftMargin="15" PageHeight="977px" 
                PageZoom="107%"></ea:datacontext>
</form>
	</body>
</HTML>
